﻿namespace SFChart.Pages
{
    using Microsoft.JSInterop;
    using System.Threading.Tasks;
    using pbr = global::Google.Protobuf.Reflection;

    public class DeviceOrientationService
    {
        public IDeviceOrientation OrientationCallback { get; set; }
        public Orientations Orientation { get; private set; } = Orientations.OrientationUnknown;

        public DeviceOrientationService()
        {
            InteropWindow.OrientationChanged += this.OrientationChanged;
        }
        private void OrientationChanged(object sender, string orientation)
        {
            this.SetOrientation(orientation);
            if (this.OrientationCallback != null)
            {
                this.OrientationCallback.OrientationChanged();
            }
        }
        public string SetOrientation(string orientation)
        {
            switch (orientation.ToLower())
            {
                case "landscape-primary":
                case "landscape-secondary":
                case "landscape":
                    this.Orientation = Orientations.Landscape;
                    break;
                case "portrait-primary":
                case "portrait-secondary":
                case "portrait":
                    this.Orientation = Orientations.Portrait;
                    break;
                default:
                    this.Orientation = Orientations.OrientationUnknown;
                    break;
            }
            return this.Orientation.ToString();
        }

        public async Task<string> GetOrientation(IJSRuntime js)
        {
            var ori = await js.InvokeAsync<string>("JsInteropWindow.getOrientation");
            this.OrientationChanged(this,ori);
            return ori;
        }
    }
    public interface IDeviceOrientation
    {
        Task OrientationChanged();
    }
    public enum Orientations
    {
        [pbr::OriginalName("OrientationUnknown")] OrientationUnknown = 0,
        [pbr::OriginalName("Landscape")] Landscape = 1,
        [pbr::OriginalName("Portrait")] Portrait = 2,
    }
}
